--VJEBE 03

-- Prvi korak je kreiranje baze
CREATE DATABASE BazaPoslovnihPartnera;

-- VANO !!!
-- Baza jest kreirana, ali se mi nismo u nju prebacili.
-- Uvijek se prebacite u novonapravljenu bazu sa USE <naziv_baze>

USE BazaPoslovnihPartnera;

-- Zatim emo kreirati entitete sa svim atributima,
-- tj. tablice sa osnovnim poljima i stranim kljuevima

-- Prvo kreiramo tablice bez stranih kljueva (koje imaju samo primarne kljueve),
CREATE TABLE PoslovniPartner
(	Naziv			nvarchar(max)	NOT NULL,
	Adresa			nvarchar(max)	NOT NULL,
	MB				int				NOT NULL,
	OIB				int				NOT NULL	PRIMARY KEY
);

-- Zatim kreiramo tablice sa stranim kljuevima koje se na njih povezuju
-- Obaveznost stranog kljua dobijamo tako da kod definicije atributa
-- stavimo NOT NULL, inae se smatra da je veza neobavezna.
-- Strani klju dodajemo poevi sa dijelom FOREIGN KEY po sintaksi:
-- FOREIGN KEY (polje_ili_polja_na_kojem_je_strani_kljuc_u_toj_tablici)
--		REFERENCES Tablica_u_kojoj_je_primarni_kljuc(polje_ili_polja__na_kojem_je_primarni_kljuc_u_toj_tablici)

CREATE TABLE Zaposlenik
(	IDZaposlenika	int				NOT NULL	PRIMARY KEY,
	Ime				nvarchar(max)	NOT NULL,
	Prezime			nvarchar(max)	NOT NULL,
	BrojTelefona	nvarchar(max)	NOT NULL,
	Mail			nvarchar(max)	NULL);
	
--naknadno dodavanje FK polja
ALTER TABLE	Zaposlenik ADD
	OIB_Pos	int	NOT NULL
		FOREIGN KEY (OIB_Pos)
			REFERENCES PoslovniPartner (OIB);

--stavljanje FK polja odmah tijekom kreiranja tablice
CREATE TABLE Zaposlenik
(	IDZaposlenika	int				NOT NULL	PRIMARY KEY,
	Ime				nvarchar(max)	NOT NULL,
	Prezime			nvarchar(max)	NOT NULL,
	BrojTelefona	nvarchar(max)	NOT NULL,
	Mail			nvarchar(max)	NULL,
	OIB_Pos			int				NOT NULL
		FOREIGN KEY (OIB_Pos)
			REFERENCES PoslovniPartner (OIB)
);